### **实验名称**

基于的NLTK分类与情感分析

### **实验目的**

通过本次实验让学生了解NLTK模块功能，并使用NLTK实现分词、数据转换和、文本分析等内容

### **实验背景**

NLTK自然语言处理工具包，是NLP研究领域常用的一个Python库，文本分析方面，它对文本进行分类意味着为其分配标签。可以通过多种方式对文本进行分类，例如，通过情感分析（积极/消极\[/中性\]），垃圾邮件分类（垃圾邮件/非垃圾邮件），文档主题等等

### **实验原理**

（NLTK）Natural Language Toolkit，自然语言处理工具包，在NLP领域中，最常使用的一个Python库。

### **实验环境**

Ubuntu 18.04

python 3.9

scikit-learn 1.3.2

scipy 1.5.4

nltk 3.8.1

### **建议课时**

4课时

### **实验步骤**

一、项目准备

nltk数据包下载：

```markup
wget http://10.90.3.2/AIHUP/ML/9/nltk_data.zip
unzip nltk_data.zip

```

环境准备

```markup
pip install nltk
```

输入jupyter notebook新建一个python3文件

```markup
jupyter notebook
```

二、实验实现词条化

在我们人为定义好文档的词条单位后，所谓的词条化是将给定的文档拆分为一系列最小单位的子序列过程，其中的每一个子序列我们称为词条（token）。例如，当我们把文档的词条单位定义为词汇或者句子的时候，我们可以将一篇文档分割为一系列的句子序列以及词汇序列，下文我们将使用NLTK模块实现词条化，在此我们将会使用到sent\_tokenize()、word\_tokenize()、PunktWordTokenizer()、WordPunctTokenizer()四种不同的词条化方法，输出的结果为包含多个词条的列表：

```python
"""
1.实验实现词条化
"""
# 1）在Python解析器中创建一个text字符串，作为样例的文本：
text = "Are you curious about tokenization? Let's see how it works! We need to analyze a couple of sentences with punctuations to see it in action."
# 2）加载NLTK模块：
from nltk.tokenize import sent_tokenize
"""
 3）调用NLTK模块的sent_tokenize()方法，对text文本进行词条化，
sent_tokenize()方法是以句子为分割单位的词条化方法：
"""
sent_tokenize_list = sent_tokenize(text)
# 4）输出结果：
print ("\nSentence tokenizer:")
print (sent_tokenize_list)
"""
 5）调用NLTK模块的word_tokenize()方法，对text文本进行词条化，
word_tokenize()方法是以单词为分割单位的词条化方法：
"""
from nltk.tokenize import word_tokenize
print ("\nWord tokenizer:")
print (word_tokenize(text))
"""
6）最后一种比较常用的单词的词条化方法是WordPunctTokenizer()，
 使用这种方法我们将会把标点作为保留对象。
"""
from nltk.tokenize import WordPunctTokenizer
word_punct_tokenizer = WordPunctTokenizer()
print ("\nWord punct tokenizer:")
print (word_punct_tokenizer.tokenize(text))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690817926195.png](./pic/image_course_1587_user_45_assignment_16458_1690817926195.png)

三、实验实现词干还原

```python
"""2.实验实现词干还原"""
# （1）导入词干还原相关的包：
from nltk.stem.porter import PorterStemmer
from nltk.stem.lancaster import LancasterStemmer
from nltk.stem.snowball import SnowballStemmer
# （2）创建样例：
words = ['table', 'probably', 'wolves', 'playing', 'is', 'dog', 'the', 'beaches', 'grounded', 'dreamt', 'envision']
# （3）调用NLTK模块中三种不同的词干还原方法：
stemmer_porter = PorterStemmer()
stemmer_lancaster = LancasterStemmer()
stemmer_snowball = SnowballStemmer('english')
# （4）设置打印输出格式：
stemmers = ['PORTER', 'LANCASTER', 'SNOWBALL']
formatted_row = '{:>16}' * (len(stemmers) + 1)
print ('\n', formatted_row.format('WORD', *stemmers), '\n')
# （5） 使用NLTK模块中词干还原方法对样例单词进行词干还原：
for word in words:
    stemmed_words = [stemmer_porter.stem(word),
    stemmer_lancaster.stem(word),stemmer_snowball.stem(word)]
    print (formatted_row.format(word, *stemmed_words))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690817951257.png](./pic/image_course_1587_user_45_assignment_16458_1690817951257.png)

四、实验实现词型归并

```python
# 3.实验实现词型归并
# （1）导入NLTK中词型归并方法：
from nltk.stem import WordNetLemmatizer
# （2）创建样例：
words = ['table', 'probably', 'wolves', 'playing', 'is',
'dog', 'the', 'beaches', 'grounded', 'dreamt', 'envision']
# （3）调用NLTK模块的WordNetLemmatizer()方法：
lemmatizer_wordnet = WordNetLemmatizer()
# （4）设置打印输出格式：
lemmatizers = ['NOUN LEMMATIZER', 'VERB LEMMATIZER']
formatted_row = '{:>24}' * (len(lemmatizers) + 1)
print ('\n', formatted_row.format('WORD', *lemmatizers), '\n')
# （5）使用NLTK模块中词型归并方法对样例单词进行词型归并：
for word in words:
    lemmatized_words = [lemmatizer_wordnet.lemmatize(word,pos='n'),
    lemmatizer_wordnet.lemmatize(word, pos='v')]
    print (formatted_row.format(word, *lemmatized_words))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690817982803.png](./pic/image_course_1587_user_45_assignment_16458_1690817982803.png)

五、实验实现文本划分

```python
"""
4.实验实现文本划分
依据特定的条件将文本划分为块，
当我们在处理非常庞大的文本数据的时候，
我们需要将文本进行分块，以便进一步的分析，
分块后的文本中，每一块的文本数据都包含数目相同的词汇：
"""

# （1）导入所需要的包：
import numpy as np
from nltk.corpus import brown
# （2）编写函数实现文本的划分：
def splitter(data, num_words):
    words = data.split(' ')
    output = []
    cur_count = 0
    cur_words = []
    for word in words:
        cur_words.append(word)
        cur_count += 1
        if cur_count == num_words:
            output.append(' '.join(cur_words))
            cur_words = []
            cur_count = 0
    output.append(' '.join(cur_words) )
    return output
# （3）设置main函数，在布朗语料库中加载前10000个单词数据：
if __name__=='__main__':
    data = ' '.join(brown.words()[:10000])
    num_words = 1700
    chunks = []
    counter = 0
# （4）结果输出：
text_chunks = splitter(data, num_words)
print ("Number of text chunks =", len(text_chunks))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690818017075.png](./pic/image_course_1587_user_45_assignment_16458_1690818017075.png)

六、实验实现数值型数据的转换

```python
# （1）导入相关包：
import numpy as np
from nltk.corpus import brown
# （2）定义一个分块函数：
# 定义一个分块函数，第一个参数是文本，第二个参数是每一块的单词数量：
def chunker(input_data, N):
    input_words = input_data.split(' ')
    output = []
    cur_chunk = []
    count = 0
    for word in input_words:
        cur_chunk.append(word)
        count += 1
        if count == N:
            output.append(' '.join(cur_chunk))
            count, cur_chunk = 0, []
    output.append(' '.join(cur_chunk))

    return output
# （3）加载布朗语料库并将文本分块：
data = ' '.join(brown.words()[:10000])
# （3）将文本分块：
num_words = 2000
chunks = []
counter = 0
text_chunks = chunker(data, num_words)
# （4）对每一块的文本数据创建字典：
for text in text_chunks:
    chunk = {'index': counter, 'text': text}
    chunks.append(chunk)
    counter += 1
# （5）通过单词出现的频率将文本数据转化为数值数据，在这里使用到了scikit - learn模块来实现：
from sklearn.feature_extraction.text import CountVectorizer

vectorizer = CountVectorizer(min_df=5, max_df=.95)
doc_term_matrix = vectorizer.fit_transform([chunk['text'] for chunk in chunks])
# （6）输出结果：
vocab = np.array(vectorizer.get_feature_names_out())
print("\nVocabulary:")
print(vocab)
print("\nDocument term matrix:")
chunk_names = ['Chunk-0', 'Chunk-1', 'Chunk-2', 'Chunk-3', 'Chunk-4']
formatted_row = '{:>12}' * (len(chunk_names) + 1)
print('\n', formatted_row.format('Word', *chunk_names), '\n')
for word, item in zip(vocab, doc_term_matrix.T):
    output = [str(x) for x in item.data]
    print(formatted_row.format(word, *output))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690818062329.png](./pic/image_course_1587_user_45_assignment_16458_1690818062329.png)

七、实验实现性别判断

在自然语言处理中通过姓名识别性别是一项有趣的事情。我们算法是通过名字中的最后几个字符以确定其性别。例如，如果名字中的最后几个字符是“la”，它很可能是一名女性的名字，如“Angela”或“Layla”。相反的，如果名字中的最后几个字符是“im”，最有可能的是男性名字，比如“Tim”或“Jim”。

```python
# （1）导入相关包：
import random
from nltk.corpus import names
from nltk import NaiveBayesClassifier
from nltk.classify import accuracy as nltk_accuracy
# （2）定义函数获取性别：
def gender_features(word, num_letters=2):
    return {'feature': word[-num_letters:].lower()}
# （3）定义main函数以及数据：
if __name__=='__main__':
    labeled_names = ([(name, 'male') for name in names.words('male.txt')] +
    [(name, 'female') for name in names.words('female.txt')])
    random.seed(7)
    random.shuffle(labeled_names)
    input_names = ['Leonardo', 'Amy', 'Sam']
    # （6）获取末尾字符：
    for i in range(1, 5):
            print ('\nNumber of letters:', i)
    featuresets = [(gender_features(n, i), gender) for (n,gender) in labeled_names]
    # （7）划分训练数据和测试数据：
    train_set, test_set = featuresets[500:], featuresets[:500]
    # （8）分类实现：
    classifier = NaiveBayesClassifier.train(train_set)
    # （9）评测分类效果：
    print ('Accuracy ==>', str(100 * nltk_accuracy(classifier,test_set)) + str('%'))
    for name in input_names:
        print (name, '==>', classifier.classify(gender_features(name, i)))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690818971372.png](./pic/image_course_1587_user_45_assignment_16458_1690818971372.png)

八、实验实现情感分析

本文中我们使用NLTK模块中的朴素贝叶斯分类器来实现文档的分类。在特征提取函数中，我们提取了所有的词。但是，在此我们注意到NLTK分类器的输入数据格式为字典格式，因此，我们下文中创建了字典格式的数据，以便我们的NLTK分类器可以使用这些数据。同时，在创建完字典型数据后，我们将数据分成训练数据集和测试数据集，我们的目的是使用训练数据训练我们的分类器，以便分类器可以将数据分为积极与消极。而当我们查看哪些单词包含的信息量最大，也就是最能体现其情感的单词的时候，我们会发现有些单词例如，“outstanding”表示积极情感，“insulting”表示消极情感。这是非常有意义的信息，因为它告诉我们什么单词被用来表明积极。

```python
"""
情感分析的实现：
"""
# （1）导入相关包：
import nltk.classify.util
from nltk.classify import NaiveBayesClassifier
from nltk.corpus import movie_reviews
# （2） 定义函数获取情感数据：
def extract_features(word_list):
    return dict([(word, True) for word in word_list])
# （3）加载数据，在这里为了方便教学我们使用NLTK自带数据：
if __name__=='__main__':
    positive_fileids = movie_reviews.fileids('pos')
    negative_fileids = movie_reviews.fileids('neg')
    # （4）将加载的数据划分为消极和积极：
    features_positive = [(extract_features(movie_reviews.words(fileids=[f])),
    'Positive') for f in positive_fileids]
    features_negative = [(extract_features(movie_reviews.words(fileids=[f])),
    'Negative') for f in negative_fileids]
    # （5）将数据划分为训练数据和测试数据：
    threshold_factor = 0.8
    threshold_positive = int(threshold_factor * len(features_positive))
    threshold_negative = int(threshold_factor * len(features_negative))
    # （6）提取特征：
    features_train = features_positive[:threshold_positive] +features_negative[:threshold_negative]
    features_test = features_positive[threshold_positive:] +features_negative[threshold_negative:]
    print ("\nNumber of training datapoints:", len(features_train))
    print ("Number of test datapoints:", len(features_test))
    # （7）调用朴素贝叶斯分类器：
    classifier = NaiveBayesClassifier.train(features_train)
    print ("\nAccuracy of the classifier:", nltk.classify.util.accuracy(classifier, features_test))
    # （8）输出分类结果：
    print ("\nTop 10 most informative words:")
    for item in classifier.most_informative_features()[:10]:
        print(item[0])
    # （9）使用分类器对情感进行预测：
    input_reviews = [
    "It is an amazing movie",
    "This is a dull movie. I would never recommend it to anyone.",
    "The cinematography is pretty great in this movie",
    "The direction was terrible and the story was all over the place"
    ]
    # （10）输出预测的结果：
    print ("\nPredictions:")
    for review in input_reviews:
        print ("\nReview:", review)
    probdist = classifier.prob_classify(extract_features(review.split()))
    pred_sentiment = probdist.max()
    print ("Predicted sentiment:", pred_sentiment)
    print ("Probability:", round(probdist.prob(pred_sentiment),2))

```

运行结果：

![image_course_1587_user_45_assignment_16458_1690819024592.png](./pic/image_course_1587_user_45_assignment_16458_1690819024592.png)

### **实验总结**

本实验学习了NLTK库的初步使用，通过八个实验，初步了解了NLTK库的应用，以及其中部分函数的使用。